﻿Public Class Form1

    ''' <summary>
    ''' Zlicza znaki w bloku tekstu.
    ''' </summary>
    ''' <param name="text">Ciąg znaków zawierający zliczane
    ''' znaki.</param>
    ''' <returns>Liczba znaków w ciągu.</returns>
    ''' <remarks></remarks>
    Private Function CountCharacters(ByVal text As String) As Integer
        Return text.Length
    End Function

    Private Sub txtWords_TextChanged(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles txtWords.TextChanged

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()

    End Sub

    ''' <summary>
    ''' Zlicza słowa w bloku tekstu.
    ''' </summary>
    ''' <param name="text">Ciąg znaków zawierający zliczane słowa.</param>
    ''' <returns>Liczba słów w ciągu znaków.</returns>
    ''' <remarks></remarks>
    Private Function CountWords(ByVal text As String) As Integer
        'Czy pole tekstowe nie jest puste?
        If text.Trim.Length = 0 Then Return 0

        'Rozbijanie tekstu na słowa.
        Dim strWords() As String = text.Split(" "c)

        'Zwracanie liczby słów.
        Return strWords.Length
    End Function

    Private Sub UpdateDisplay()
        'Czy program ma zliczać słowa?
        If radCountWords.Checked Then
            'Aktualizacja wyników.
            lblResults.Text = CountWords(txtWords.Text) & " słów"
        Else
            'Aktualizacja wyników.
            lblResults.Text = CountCharacters(txtWords.Text) & " znaków"
        End If
    End Sub

    Private Sub radCountWords_CheckedChanged(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles radCountWords.CheckedChanged

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()
    End Sub

    Private Sub radCountChars_CheckedChanged(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles radCountChars.CheckedChanged

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()
    End Sub

End Class
